/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base.util;

import filenet.vw.api.VWException;
import filenet.vw.base.VWDebug;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Digest {
    private static final String DEFAULT_DIGEST_ALGORITHM = "SHA1";

    public static byte[] getDigest(String fileName) {
        try {
            return Digest.getDigest(fileName, DEFAULT_DIGEST_ALGORITHM);
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public static byte[] getDigest(String fileName, String digestAlgorithm) throws VWException {
        byte[] result = null;
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(fileName));
            result = Digest.getDigest(in, digestAlgorithm);
            in.close();
        }
        catch (IOException ioe) {
            throw new VWException("vw.base.util.Digest.getDigest1.", ioe.getMessage());
        }
        return result;
    }

    public static byte[] getDigest(InputStream inputStream) {
        try {
            return Digest.getDigest(inputStream, DEFAULT_DIGEST_ALGORITHM);
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public static byte[] getDigest(InputStream inputStream, String digestAlgorithm) throws VWException {
        byte[] result = null;
        try {
            int bytesRead;
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            int MY_BUF_SIZE = 4096;
            byte[] myBuf = new byte[4096];
            while (0 < (bytesRead = inputStream.read(myBuf))) {
                md.update(myBuf, 0, bytesRead);
            }
            result = md.digest();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new VWException("vw.base.util.Digest.getDigest2.", nsae.getMessage());
        }
        catch (IOException ioe) {
            throw new VWException("vw.base.util.Digest.getDigest3.", ioe.getMessage());
        }
        return result;
    }

    public static byte[] getDigest(char[] input) {
        return Digest.getDigest(input, DEFAULT_DIGEST_ALGORITHM);
    }

    public static byte[] getDigest(char[] input, String digestAlgorithm) {
        try {
            ByteBuffer bb = ByteBuffer.allocate(input.length * 2);
            CharBuffer cb = bb.asCharBuffer();
            cb.put(input);
            byte[] result = Digest.getDigest(bb.array(), digestAlgorithm);
            return result;
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public static byte[] getDigest(byte[] input) {
        try {
            return Digest.getDigest(input, DEFAULT_DIGEST_ALGORITHM);
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public static byte[] getDigest(byte[] input, String digestAlgorithm) throws VWException {
        byte[] result = null;
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            md.update(input);
            result = md.digest();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new VWException("vw.base.util.Digest.getDigest4", nsae.getMessage());
        }
        return result;
    }
}

